/*
 *  Globals.cpp
 *  Pirates2011
 *
 *  Created by Alan Dorin on 25/03/11.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */


#include "Globals.h"
#include <iostream>

Globals::Globals(long initNumGolds, long initNumShips, long initGridSize, long initNumRocks, long initNumSimulationTimeSteps, long initNumSimulationRepeatRuns)
{
	seaNumGolds = initNumGolds;
	seaNumShips = initNumShips;
	seaGridSize = initGridSize;
	seaNumRocks = initNumRocks + ((4 * initGridSize)-4);	// the number of rocks specified PLUS the number of rocks neded to surround the boundary
	
	numSimulationTimeSteps	= initNumSimulationTimeSteps;
	numSimulationRepeatRuns		= initNumSimulationRepeatRuns;
}

Globals::NeighbourDirection getAdjacentDirection(Globals::NeighbourDirection direction)
{
	switch (direction)
	{
		case Globals::neighbourUp:
			return Globals::neighbourDown;
		break;
		case Globals::neighbourDown:
			return Globals::neighbourUp;
		break;
		case Globals::neighbourRight:
			return Globals::neighbourLeft;
		break;
		case Globals::neighbourLeft:
			return Globals::neighbourRight;
		break;
		case Globals::neighbourEND_MARKER:
			std::cerr << "\nERROR (Globals::getAdjacentDirection) : switch for NeighbourDirection=neighbourEND_MARKER!";
		exit(1);
		default:
			std::cerr << "\nERROR (Globals::getAdjacentDirection) : fallen off switch for NeighbourDirection!";
		exit(1);
	}
	
	return Globals::neighbourUp; // stop compiler warning
}

long getAdjacentIndexX(Globals::NeighbourDirection direction, long curIndex, long xDimension)
{
	long newIndex;
	
	switch (direction)
	{
		case Globals::neighbourUp:
		case Globals::neighbourDown:
			return curIndex;
		break;
		case Globals::neighbourRight:
			newIndex = curIndex + 1;
			if (newIndex >= xDimension)	{ return 0; }
			else						{ return newIndex; }
		break;
		case Globals::neighbourLeft:
			newIndex = curIndex - 1;
			if (newIndex < 0)	{ return xDimension-1; }
			else				{ return newIndex; }
		break;
		default:
			std::cerr << "\nERROR (Globals::getAdjacentIndexX) : fallen off switch for NeighbourDirection!";
		exit(1);
	}
	
	return -1; // stop compiler warning
}

long getAdjacentIndexY(Globals::NeighbourDirection direction, long curIndex, long yDimension)
{
	long newIndex;
	
	switch (direction)
	{
		case Globals::neighbourUp:
			newIndex = curIndex + 1;
			if (newIndex >= yDimension)	{ return 0; }
			else						{ return newIndex; }
		break;
		case Globals::neighbourDown:
			newIndex = curIndex - 1;
			if (newIndex < 0)	{ return yDimension-1; }
			else				{ return newIndex; }
		break;
		case Globals::neighbourRight:
		case Globals::neighbourLeft:
			return curIndex;
		break;
		default:
			std::cerr << "\nERROR (Globals::getAdjacentIndexY) : fallen off switch for NeighbourDirection!";
		exit(1);
	}
	
	return -1; // stop compiler warning
}

// Turning clockwise around the grid Up > Right > Down > Left > Up
Globals::NeighbourDirection getClockwiseNeighbourDirection(Globals::NeighbourDirection currentDirection)
{
	switch (currentDirection)
	{
		case Globals::neighbourUp:
			return Globals::neighbourRight;
		break;
		
		case Globals::neighbourRight:
			return Globals::neighbourDown;
		break;
		
		case Globals::neighbourDown:
			return Globals::neighbourLeft;
		break;
		
		case Globals::neighbourLeft:
			return Globals::neighbourUp;
		break;
		
		default:
			std::cerr << "\nERROR (Globals::getClockwiseNeighbourDirection) : fallen off switch for NeighbourDirection!";
		exit(1);
	}
	
	return Globals::neighbourUp; // stop compiler warning
}

// Turning anti-clockwise around the grid Up > Left > Down > Right > Up
Globals::NeighbourDirection getAnticlockwiseNeighbourDirection(Globals::NeighbourDirection currentDirection)
{
	switch (currentDirection)
	{
		case Globals::neighbourUp:
			return Globals::neighbourLeft;
		break;
		
		case Globals::neighbourLeft:
			return Globals::neighbourDown;
		break;
		
		case Globals::neighbourDown:
			return Globals::neighbourRight;
		break;
		
		case Globals::neighbourRight:
			return Globals::neighbourUp;
		break;
		
		default:
			std::cerr << "\nERROR (Globals::getAnticlockwiseNeighbourDirection) : fallen off switch for NeighbourDirection!";
		exit(1);
	}
	
	return Globals::neighbourUp; // stop compiler warning

}
